 // Navigate Tabs. Allows for lots of information to be displayed on a page in a more compact form.
 // Maintained by [[User:Darklama]]
 
 function Navigate_Tabs()
 {
   function select_tab(id) {
     if (!id) return false;
     var contents = document.getElementById(id.substring(1));
     if (contents && hasClass(contents, 'contents') && hasClass(contents.parentNode, "navtabs")) {
       for (var tabs = contents.parentNode.firstChild; tabs != null; tabs = tabs.nextSibling) {
         if (hasClass(tabs, "tabs") || (tabs.nodeName.toLowerCase() == 'p' && hasClass(tabs.firstChild, "tabs"))) {
           var links = tabs.getElementsByTagName("a");
           for (var i = 0; link = links[i]; i++) {
             if (link.hash) {
               if (hasClass(link.parentNode, "selected"))
                 link.parentNode.className = link.parentNode.className.replace(/(^|\s)selected(\s|$)/g, "$1inactive$2");
               else if (!hasClass(link.parentNode, "inactive"))
                 link.parentNode.className += (link.parentNode.className ? " " : "") + "inactive";
               if (link.hash == id)
                 link.parentNode.className = link.parentNode.className.replace(/(^|\s)inactive(\s|$)/g, "$1selected$2");
             }
           }
         } else if (hasClass(tabs, "contents")) {
           tabs.style.display = "none";
         }
       }
       contents.style.display = "block";
     }
     return false;
   }
   
   function clicked_tab(e)
   {
     var target;
     if (!e) e = window.event;
     if (e.target) target = e.target;
     else if (e.srcElement) target = e.srcElement;
     else return;
     if (target.nodeType && target.nodeType == 3)
       target = target.parentNode;
     if (target.nodeType && (target.tagName.toLowerCase() != 'a' || !target.hash))
       return;
     if (e.preventDefault) e.preventDefault(); else e.returnValue = false;
     
     return select_tab(target.hash ? target.hash : target);
   }
   
   function find(tree) {
     var nav, tabs, tab;
     
     if (!tree)
       return;
     for (var i=0; i < tree.length; i++) {
       var node = tree[i];
       if (!nav && hasClass(node, 'navtabs')) {
         node.onclick = clicked_tab;
         nav = node;
       } else if (nav && !tabs && hasClass(node, 'tabs')) {
         tabs = node;
       } else if (tabs && !tab && hasClass(node, 'selected')) {
         if (node.tagName.toLowerCase() == 'a' && node.hash) {
           select_tab(node.hash);
           nav = tabs = null;
         } else {
           tab = node;
         }
       } else if (tab && node.tagName.toLowerCase() == 'a' && node.hash) {
         select_tab(node.hash);
         tab = tabs = nav = null;
       } else if (hasClass(node, 'navtabs')) {
         find(tree.slice(i));
       }
     }
   }
   
   var page = document.getElementById("bodyContent") || document.getElementById("article") || document.getElementById("content");
   if (page)
     find(page.getElementsByTagName("*"));
 }
 
 addOnloadHook(Navigate_Tabs);